rule Win32_Ransomware_Nemty : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "NEMTY"
        description         = "Yara rule that detects Nemty ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Nemty"
        tc_detection_factor = 5

    strings:

        $remote_connection_p1 = {
            55 8B EC 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 57 33 DB 68 ?? ?? ?? ?? 8D 75 
            ?? 89 5D ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? ?? ?? ?? 83 78 ?? ?? 59 59 72 ?? 8B 00 
            53 53 50 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 6A ?? 33 FF 8D 75 ?? E8 ?? ?? ?? ?? 6A 
            ?? 8D 75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 75 ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? 
            ?? ?? ?? 83 78 ?? ?? 59 59 72 ?? 8B 00 53 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? 
            ?? ?? ?? 3D ?? ?? ?? ?? 74 ?? 32 DB EB ?? B3 ?? 6A ?? 33 FF 8D 75 ?? E8 ?? ?? ?? ?? 
            6A ?? 8D 75 ?? E8 ?? ?? ?? ?? 84 DB 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 75 ?? E8 ?? 
            ?? ?? ?? 50 8D 45 ?? E8 ?? ?? ?? ?? 83 78 ?? ?? 59 59 72 ?? 8B 00 8B 1D ?? ?? ?? ?? 
            50 FF D3 6A ?? 33 FF 8D 75 ?? 89 45 ?? E8 ?? ?? ?? ?? 6A ?? 8D 75 ?? E8 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 75 ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? ?? ?? ?? 83 78 ?? ?? 59 59 
            72 ?? 8B 00 50 FF D3 33 DB 43 53 33 FF 8D 75 ?? 89 45 ?? E8 ?? ?? ?? ?? 53 8D 75 ?? 
            E8 ?? ?? ?? ?? FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 59 59 FF 75 ?? FF
        }

        $remote_connection_p2 = {
            D6 FF 75 ?? FF D6 68 ?? ?? ?? ?? 8D 75 ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? ?? ?? ?? 
            83 78 ?? ?? 59 59 72 ?? 8B 00 50 FF 15 ?? ?? ?? ?? 53 33 FF 8D 75 ?? E8 ?? ?? ?? ?? 
            53 8D 75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 75 ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? 
            ?? ?? ?? 83 78 ?? ?? 59 59 72 ?? 8B 00 33 C9 51 51 51 50 68 ?? ?? ?? ?? 51 FF 15 ?? 
            ?? ?? ?? 53 33 FF 8D 75 ?? E8 ?? ?? ?? ?? 53 8D 75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 8B 4D ?? 6A ?? 5A 8B C1 39 55 ?? 73 ?? 8D 45 ?? 03 45 ?? 39 55 ?? 
            73 ?? 8D 4D ?? EB ?? 80 39 ?? 75 ?? C6 01 ?? 41 3B C8 75 ?? 8B 45 ?? 39 55 ?? 73 ?? 
            8D 45 ?? 03 45 ?? 8B 4D ?? 39 55 ?? 73 ?? 8D 4D ?? EB ?? 80 39 ?? 75 ?? C6 01 ?? 41 
            3B C8 75 ?? 8B 45 ?? 39 55 ?? 73 ?? 8D 45 ?? 03 45 ?? 8B 4D ?? 39 55 ?? 73 ?? 8D 4D 
            ?? EB ?? 80 39 ?? 75 ?? C6 01 ?? 41 3B C8 75 ?? 83 EC ?? 8D 45 ?? 8B F4 50 E8 ?? ?? 
            ?? ?? 83 EC ?? 8B F4 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 33 
            FF 8D 75 ?? E8 ?? ?? ?? ?? 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }

        $enum_resources_p1 = {
            55 8B EC 83 E4 ?? 83 EC ?? A1 ?? ?? ?? ?? 33 C4 89 44 24 ?? 53 56 57 FF 15 ?? ?? ?? 
            ?? 83 64 24 ?? ?? 89 44 24 ?? BB ?? ?? ?? ?? 8B 54 24 ?? 8B 4C 24 ?? D3 EA 33 C0 40 
            23 D0 0F 84 ?? ?? ?? ?? 83 64 24 ?? ?? 6A ?? 80 C1 ?? 5F 88 4C 24 ?? FF 74 24 ?? 8D 
            74 24 ?? 89 7C 24 ?? C6 44 24 ?? ?? E8 ?? ?? ?? ?? 83 64 24 ?? ?? 8B 74 24 ?? 53 89 
            7C 24 ?? C6 44 24 ?? ?? E8 ?? ?? ?? ?? 59 03 C6 8D 4C 24 ?? E8 ?? ?? ?? ?? 6A ?? 8D 
            44 24 ?? 50 83 C8 ?? 8D 74 24 ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 8B F8 53 8B C6 
            E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 8B 44 24 ?? 73 ?? 8B C6 50 FF 15 ?? ?? ?? ?? 6A ?? 33 
            FF 8D 74 24 ?? 89 44 24 ?? E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 75 ?? 53 E8 ?? ?? ?? ?? 59 
            8B F8 53 8D 44 24 ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 
            33 FF 8D 74 24 ?? E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 75 ?? 53 E8 ?? ?? ?? ?? 59 8B F8 53 
            8D 44 24 ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 68
        }

        $enum_resources_p2 = {
            8D 44 24 ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 33 FF 8D 
            74 24 ?? E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 75 ?? 53 E8 ?? ?? ?? ?? 59 8B F8 53 8D 44 24 
            ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? E8 ?? ?? ?? ?? 8D 44 24 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 33 FF 8D 74 24 ?? 
            E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 8B 44 24 ?? 73 ?? 8D 44 24 ?? 6A ?? 8D 4C 24 ?? 51 8D 
            4C 24 ?? 51 50 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 0F AC C8 ?? 89 44 24 ?? 8D 
            44 24 ?? BE ?? ?? ?? ?? C1 E9 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 0F AC C8 ?? 
            89 44 24 ?? 8D 44 24 ?? BE ?? ?? ?? ?? C1 E9 ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 2B 44 24 
            ?? 8B 4C 24 ?? 1B 4C 24 ?? BE ?? ?? ?? ?? 0F AC C8 ?? 89 44 24 ?? 8D 44 24 ?? C1 E9 
            ?? E8 ?? ?? ?? ?? 6A ?? 33 FF 8D 74 24 ?? E8 ?? ?? ?? ?? FF 44 24 ?? 83 7C 24 ?? ?? 
            0F 8C ?? ?? ?? ?? 8B 4C 24 ?? 5F 5E 5B 33 CC E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $find_files_1_p1 = {
            6A ?? 8D 74 24 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 
            0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 
            E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 
            59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 
            44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? 
            ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84
        }

        $find_files_1_p2 = {
            C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? E8 ?? ?? ?? ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? 
            ?? 59 84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 0F 
            85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 75 ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 75 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? 
            ?? 59 84 C0 75 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 75 ?? 68 ?? ?? 
            ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 59 84 C0 75 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? 
            ?? ?? 59 84 C0 75 ?? 83 EC ?? 8D 44 24 ?? 8B F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 6A ?? 33 FF 8D 74 24 ?? E8 ?? ?? ?? ?? 6A ?? 8D 74 24 ?? E8 ?? ?? ?? ?? 8D 84 
            24 ?? ?? ?? ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 74 24 ?? 
            FF 15 
        }

        $find_files_2_p1 = {
            8D 44 24 ?? 8D 8C 24 ?? ?? ?? ?? 51 50 FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 0F 84 
            ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 
            84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? 
            ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? BF ?? ?? ?? ?? 57 8D 
            84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 57 8D 84 24 ?? ?? ?? ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 
            24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24
        }

        $find_files_2_p2 = { 
            50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 
            0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 84 24 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? 
            ?? ?? ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 8D 44 24 ?? E8 ?? 
            ?? ?? ?? 83 4C 24 ?? ?? 83 EC ?? 8B C4 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? 8D 4C 
            24 ?? 8B C4 51 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 84 24 ?? ?? 
            ?? ?? 50 8D 44 24 ?? E8 ?? ?? ?? ?? 83 4C 24 ?? ?? 83 EC ?? 8B C4 68 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 EC ?? 8D 8C 24 ?? ?? ?? ?? 8B C4 51 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 
            83 C4 ?? 85 C0 75 ?? 32 DB EB ?? B3 ?? F6 44 24 ?? ?? 74 ?? 83 64 24 ?? ?? 6A ?? 33 
            FF 8D 74 24 ?? E8 ?? ?? ?? ?? F6 44 24 ?? ?? 74 ?? 83 64 24 ?? ?? 6A ?? 33 FF 8D 74 
        }

        $find_files_2_p3 = {
            24 ?? E8 ?? ?? ?? ?? 84 DB 0F 85 ?? ?? ?? ?? F6 84 24 ?? ?? ?? ?? ?? 8D 84 24 ?? ?? 
            ?? ?? 50 0F 84 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B F0 8B 
            46 ?? 59 83 C9 ?? 2B C8 83 F9 ?? 0F 86 ?? ?? ?? ?? 8D 58 ?? 6A ?? 8B C6 E8 ?? ?? ?? 
            ?? 84 C0 74 ?? 83 7E ?? ?? 8B 4E ?? 72 ?? 8B 06 EB ?? 8B C6 6A ?? 5A 66 89 14 48 83 
            7E ?? ?? 89 5E ?? 72 ?? 8B 06 EB ?? 8B C6 33 C9 66 89 0C 58 8B DE 8D 74 24 ?? E8 ?? 
            ?? ?? ?? 8B DE 8D 44 24 ?? E8 ?? ?? ?? ?? 6A ?? 33 FF E8 ?? ?? ?? ?? 6A ?? 8D 74 24 
            ?? E8 ?? ?? ?? ?? 83 EC ?? 8D 44 24 ?? 8B F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 44 
            24 ?? 8B F4 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8D 44 24 ?? E8 
            ?? ?? ?? ?? 8D 44 24 ?? 50 8D 44 24 ?? E8 ?? ?? ?? ?? 59 6A ?? 33 FF 8D 74 24 ?? E8 
            ?? ?? ?? ?? 6A ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 40 33 C9 8D 74 24 ?? E8 ?? ?? ?? ?? 8D 
            84 24 ?? ?? ?? ?? 50 8D 44 24 ?? E8 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 44 24 ?? E8 ?? ?? 
            ?? ?? 59 6A ?? 8D 74 24 ?? E8 ?? ?? ?? ?? 6A ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 40 33 C9 
            8D 74 24 ?? E8 
        }

        $encrypt_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 56 8B D9 33 F6 C7 43 ?? 
            ?? ?? ?? ?? 89 73 ?? C6 03 ?? A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 57 2B C1 6A ?? 99 5F 
            F7 FF 89 9D ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 85 C0 74 ?? 89 B5 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 83 EC ?? 03 C1 8B F4 50 E8 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A 
            ?? 50 83 C8 ?? 8B F3 E8 ?? ?? ?? ?? 6A ?? 33 FF 8D 75 ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? 
            ?? 8B 0D ?? ?? ?? ?? 2B C1 6A ?? 99 5E F7 FE FF 85 ?? ?? ?? ?? 83 85 ?? ?? ?? ?? ?? 
            39 85 ?? ?? ?? ?? 72 ?? 8B 53 ?? 6A ?? 5F C6 85 ?? ?? ?? ?? ?? 3B D7 72 ?? 8B 0B EB 
            ?? 8B CB 8B 43 ?? 03 C1 3B D7 72 ?? 8B 0B EB ?? 8B CB 50 51 8D 85 ?? ?? ?? ?? 50 8D 
            85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 39 7B ?? 72 ?? 8B 03 EB ?? 8B C3 8B 5B ?? 8B 
            B5 ?? ?? ?? ?? 03 D8 53 FF B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 
            4E ?? C6 85 ?? ?? ?? ?? ?? 3B CF 72 ?? 8B 16 EB ?? 8B D6 8B 46 ?? 03 C2 3B CF 72 ?? 
            8B 0E EB ?? 8B CE 50 51 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 39 7E ?? 72 ?? 8B 0E EB ?? 8B CE 8B 46 ?? 03 C1 50 FF B5 ?? ?? ?? ?? 8D 9D ?? ?? 
            ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B 46 ?? 50 89 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4E
        }

        $encrypt_files_p2 = {
            89 85 ?? ?? ?? ?? 3B CF 72 ?? 8B 16 EB ?? 8B D6 8B 46 ?? 03 C2 3B CF 72 ?? 8B 0E EB 
            ?? 8B CE 3B C8 74 ?? 8B B5 ?? ?? ?? ?? 2B F1 8A 11 88 14 0E 41 3B C8 75 ?? 8D 45 ?? 
            50 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 75 ?? 8B F8 C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            50 8D 45 ?? E8 ?? ?? ?? ?? 8B F0 8B 46 ?? 8B 56 ?? 59 59 8B 4F ?? 2B C2 3B C8 76 ?? 
            8B 47 ?? 2B C1 3B C2 72 ?? 56 8B F7 E8 ?? ?? ?? ?? EB ?? 6A ?? 57 83 C8 ?? E8 ?? ?? 
            ?? ?? 8B D8 8D 75 ?? E8 ?? ?? ?? ?? 8B C6 68 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 83 78 ?? ?? 59 59 72 ?? 8B 00 33 DB 53 68 ?? ?? ?? ?? 6A ?? 53 53 68 ?? ?? 
            ?? ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 33 FF 8D B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 6A ?? 8D 75 ?? E8 ?? ?? ?? ?? 6A ?? 8D 75 ?? E8 ?? ?? ?? ?? 6A ?? 8D 75 ?? E8 
            ?? ?? ?? ?? 6A ?? 8D 75 ?? E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 3B F3 74 ?? 53 53 53 56 
            FF 15 ?? ?? ?? ?? 53 8D 85 ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 56 FF 
            15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 59 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($find_files_1_p*)
        ) and 
        (
            all of ($find_files_2_p*)
        ) and 
        (
            all of ($enum_resources_p*)
        ) and 
        (
            all of ($encrypt_files_p*)
        ) and 
        (
            all of ($remote_connection_p*)
        )
}